//=============================================================================
// TournamentScoreBoard
//=============================================================================
class rpg_SB extends TournamentScoreBoard;

#exec TEXTURE IMPORT NAME=Logo FILE=Textures\Logo.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=Bottom FILE=Textures\Bottom.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=BottomLeft FILE=Textures\BottomLeft.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=BottomRight FILE=Textures\BottomRight.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=Left FILE=Textures\Left.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=Right FILE=Textures\Right.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=Topp FILE=Textures\Top.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=TopLeft FILE=Textures\TopLeft.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=TopRight FILE=Textures\TopRight.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=AddToDamage FILE=Textures\AddToDamage.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=ReduceDamageTaken FILE=Textures\ReduceDamageTaken.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=AddLightningDamage FILE=Textures\AddLightningDamage.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=RegainHealth FILE=Textures\RegainHealth.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=AddFireDamage FILE=Textures\AddFireDamage.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=AddPoisonDamage FILE=Textures\AddPoisonDamage.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=AddColdDamage FILE=Textures\AddColdDamage.bmp  MIPS=ON
#exec TEXTURE IMPORT NAME=RegainAmmo FILE=Textures\RegainAmmo.bmp  MIPS=ON

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor,WallPaperColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;

//replicated Variables used to show on the SB:
var int ShowLevel,
	ShowHealthRegain,
	ShowAmmoRegain,
	ShowReducedDamage,
	ShowAddToDamage,
	ShowFireDamage,
	ShowLightningDamage,
	ShowPoisonDamage,
	ShowColdDamage;

//This function finds the correct variables to show on SB
function GrabPlayerVars()
{
local rpg_GRI TGRI;
local PlayerPawn P;
local Canvas Canvas;

	//TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	//TGRI = TournamentGameReplicationInfo(P.GameReplicationInfo);
	TGRI = rpg_GRI(PlayerPawn(Owner).GameReplicationInfo);

	if ( TGRI.TPlayers0 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel0;
		ShowHealthRegain = TGRI.TRegainHealth0;
		ShowAmmoRegain = TGRI.TRegainAmmo0;
		ShowReducedDamage = TGRI.TReduceDamage0;
		ShowAddToDamage = TGRI.TAddToDamage0;
		ShowFireDamage = TGRI.TAddFireDamage0;
		ShowLightningDamage = TGRI.TAddLightningDamage0;
		ShowPoisonDamage = TGRI.TAddPoisonDamage0;
		ShowColdDamage = TGRI.TAddColdDamage0;
		}
	else if ( TGRI.TPlayers1 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel1;
		ShowHealthRegain = TGRI.TRegainHealth1;
		ShowAmmoRegain = TGRI.TRegainAmmo1;
		ShowReducedDamage = TGRI.TReduceDamage1;
		ShowAddToDamage = TGRI.TAddToDamage1;
		ShowFireDamage = TGRI.TAddFireDamage1;
		ShowLightningDamage = TGRI.TAddLightningDamage1;
		ShowPoisonDamage = TGRI.TAddPoisonDamage1;
		ShowColdDamage = TGRI.TAddColdDamage1;
		}
	else if ( TGRI.TPlayers2 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel2;
		ShowHealthRegain = TGRI.TRegainHealth2;
		ShowAmmoRegain = TGRI.TRegainAmmo2;
		ShowReducedDamage = TGRI.TReduceDamage2;
		ShowAddToDamage = TGRI.TAddToDamage2;
		ShowFireDamage = TGRI.TAddFireDamage2;
		ShowLightningDamage = TGRI.TAddLightningDamage2;
		ShowPoisonDamage = TGRI.TAddPoisonDamage2;
		ShowColdDamage = TGRI.TAddColdDamage2;
		}
	else if ( TGRI.TPlayers3 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel3;
		ShowHealthRegain = TGRI.TRegainHealth3;
		ShowAmmoRegain = TGRI.TRegainAmmo3;
		ShowReducedDamage = TGRI.TReduceDamage3;
		ShowAddToDamage = TGRI.TAddToDamage3;
		ShowFireDamage = TGRI.TAddFireDamage3;
		ShowLightningDamage = TGRI.TAddLightningDamage3;
		ShowPoisonDamage = TGRI.TAddPoisonDamage3;
		ShowColdDamage = TGRI.TAddColdDamage3;
		}
	else if ( TGRI.TPlayers4 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel4;
		ShowHealthRegain = TGRI.TRegainHealth4;
		ShowAmmoRegain = TGRI.TRegainAmmo4;
		ShowReducedDamage = TGRI.TReduceDamage4;
		ShowAddToDamage = TGRI.TAddToDamage4;
		ShowFireDamage = TGRI.TAddFireDamage4;
		ShowLightningDamage = TGRI.TAddLightningDamage4;
		ShowPoisonDamage = TGRI.TAddPoisonDamage4;
		ShowColdDamage = TGRI.TAddColdDamage4;
		}
	else if ( TGRI.TPlayers5 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel5;
		ShowHealthRegain = TGRI.TRegainHealth5;
		ShowAmmoRegain = TGRI.TRegainAmmo5;
		ShowReducedDamage = TGRI.TReduceDamage5;
		ShowAddToDamage = TGRI.TAddToDamage5;
		ShowFireDamage = TGRI.TAddFireDamage5;
		ShowLightningDamage = TGRI.TAddLightningDamage5;
		ShowPoisonDamage = TGRI.TAddPoisonDamage5;
		ShowColdDamage = TGRI.TAddColdDamage5;
		}
	else if ( TGRI.TPlayers6 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel6;
		ShowHealthRegain = TGRI.TRegainHealth6;
		ShowAmmoRegain = TGRI.TRegainAmmo6;
		ShowReducedDamage = TGRI.TReduceDamage6;
		ShowAddToDamage = TGRI.TAddToDamage6;
		ShowFireDamage = TGRI.TAddFireDamage6;
		ShowLightningDamage = TGRI.TAddLightningDamage6;
		ShowPoisonDamage = TGRI.TAddPoisonDamage6;
		ShowColdDamage = TGRI.TAddColdDamage6;
		}
	else if ( TGRI.TPlayers7 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel7;
		ShowHealthRegain = TGRI.TRegainHealth7;
		ShowAmmoRegain = TGRI.TRegainAmmo7;
		ShowReducedDamage = TGRI.TReduceDamage7;
		ShowAddToDamage = TGRI.TAddToDamage7;
		ShowFireDamage = TGRI.TAddFireDamage7;
		ShowLightningDamage = TGRI.TAddLightningDamage7;
		ShowPoisonDamage = TGRI.TAddPoisonDamage7;
		ShowColdDamage = TGRI.TAddColdDamage7;
		}
	else if ( TGRI.TPlayers8 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel8;
		ShowHealthRegain = TGRI.TRegainHealth8;
		ShowAmmoRegain = TGRI.TRegainAmmo8;
		ShowReducedDamage = TGRI.TReduceDamage8;
		ShowAddToDamage = TGRI.TAddToDamage8;
		ShowFireDamage = TGRI.TAddFireDamage8;
		ShowLightningDamage = TGRI.TAddLightningDamage8;
		ShowPoisonDamage = TGRI.TAddPoisonDamage8;
		ShowColdDamage = TGRI.TAddColdDamage8;
		}
	else if ( TGRI.TPlayers9 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel9;
		ShowHealthRegain = TGRI.TRegainHealth9;
		ShowAmmoRegain = TGRI.TRegainAmmo9;
		ShowReducedDamage = TGRI.TReduceDamage9;
		ShowAddToDamage = TGRI.TAddToDamage9;
		ShowFireDamage = TGRI.TAddFireDamage9;
		ShowLightningDamage = TGRI.TAddLightningDamage9;
		ShowPoisonDamage = TGRI.TAddPoisonDamage9;
		ShowColdDamage = TGRI.TAddColdDamage9;
		}
	else if ( TGRI.TPlayers10 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel10;
		ShowHealthRegain = TGRI.TRegainHealth10;
		ShowAmmoRegain = TGRI.TRegainAmmo10;
		ShowReducedDamage = TGRI.TReduceDamage10;
		ShowAddToDamage = TGRI.TAddToDamage10;
		ShowFireDamage = TGRI.TAddFireDamage10;
		ShowLightningDamage = TGRI.TAddLightningDamage10;
		ShowPoisonDamage = TGRI.TAddPoisonDamage10;
		ShowColdDamage = TGRI.TAddColdDamage10;
		}
	else if ( TGRI.TPlayers11 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel11;
		ShowHealthRegain = TGRI.TRegainHealth11;
		ShowAmmoRegain = TGRI.TRegainAmmo11;
		ShowReducedDamage = TGRI.TReduceDamage11;
		ShowAddToDamage = TGRI.TAddToDamage11;
		ShowFireDamage = TGRI.TAddFireDamage11;
		ShowLightningDamage = TGRI.TAddLightningDamage11;
		ShowPoisonDamage = TGRI.TAddPoisonDamage11;
		ShowColdDamage = TGRI.TAddColdDamage11;
		}
	else if ( TGRI.TPlayers12 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel12;
		ShowHealthRegain = TGRI.TRegainHealth12;
		ShowAmmoRegain = TGRI.TRegainAmmo12;
		ShowReducedDamage = TGRI.TReduceDamage12;
		ShowAddToDamage = TGRI.TAddToDamage12;
		ShowFireDamage = TGRI.TAddFireDamage12;
		ShowLightningDamage = TGRI.TAddLightningDamage12;
		ShowPoisonDamage = TGRI.TAddPoisonDamage12;
		ShowColdDamage = TGRI.TAddColdDamage12;
		}
	else if ( TGRI.TPlayers13 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel13;
		ShowHealthRegain = TGRI.TRegainHealth13;
		ShowAmmoRegain = TGRI.TRegainAmmo13;
		ShowReducedDamage = TGRI.TReduceDamage13;
		ShowAddToDamage = TGRI.TAddToDamage13;
		ShowFireDamage = TGRI.TAddFireDamage13;
		ShowLightningDamage = TGRI.TAddLightningDamage13;
		ShowPoisonDamage = TGRI.TAddPoisonDamage13;
		ShowColdDamage = TGRI.TAddColdDamage13;
		}
	else if ( TGRI.TPlayers14 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel14;
		ShowHealthRegain = TGRI.TRegainHealth14;
		ShowAmmoRegain = TGRI.TRegainAmmo14;
		ShowReducedDamage = TGRI.TReduceDamage14;
		ShowAddToDamage = TGRI.TAddToDamage14;
		ShowFireDamage = TGRI.TAddFireDamage14;
		ShowLightningDamage = TGRI.TAddLightningDamage14;
		ShowPoisonDamage = TGRI.TAddPoisonDamage14;
		ShowColdDamage = TGRI.TAddColdDamage14;
		}
	else if ( TGRI.TPlayers15 == PlayerPawn(Owner).PlayerReplicationInfo.PlayerName )
		{
		ShowLevel = TGRI.TLevel15;
		ShowHealthRegain = TGRI.TRegainHealth15;
		ShowAmmoRegain = TGRI.TRegainAmmo15;
		ShowReducedDamage = TGRI.TReduceDamage15;
		ShowAddToDamage = TGRI.TAddToDamage15;
		ShowFireDamage = TGRI.TAddFireDamage15;
		ShowLightningDamage = TGRI.TAddLightningDamage15;
		ShowPoisonDamage = TGRI.TAddPoisonDamage15;
		ShowColdDamage = TGRI.TAddColdDamage15;
		}
}


function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
local float X,Y;

	X = Canvas.ClipX;
	Y = Canvas.ClipY;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 8);
	Canvas.DrawTile(Texture'Logo', 512, 128, 0, 0, 512, 128);

	Canvas.Style = Style;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(128, 128);
	Canvas.DrawText("PlayerName: "@PlayerPawn(Owner).PlayerReplicationInfo.PlayerName, false );
	Canvas.SetPos(128, 160);
	Canvas.DrawText("Level: "@ShowLevel, false );
	Canvas.SetPos(128, 192);
	Canvas.DrawText("HealthRegain: "@ShowHealthRegain, false );
	Canvas.SetPos(128, 224);
	Canvas.DrawText("AmmoRegain: "@ShowAmmoRegain, false );
	Canvas.SetPos(128, 256);
	Canvas.DrawText("ReducedDamage: "@ShowReducedDamage, false );
	Canvas.SetPos(128, 288);
	Canvas.DrawText("AddToDamage: "@ShowAddToDamage, false );
	Canvas.SetPos(128, 320);
	Canvas.DrawText("FireDamage: "@ShowFireDamage, false );
	Canvas.SetPos(128, 352);
	Canvas.DrawText("LightningDamage: "@ShowLightningDamage, false );
	Canvas.SetPos(128, 384);
	Canvas.DrawText("PoisonDamage: "@ShowPoisonDamage, false );
	Canvas.SetPos(128, 416);
	Canvas.DrawText("ColdDamage: "@ShowColdDamage, false );
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.DrawText(TGRI.GameName);
	Canvas.StrLen("Test", XL, YL);
	Canvas.SetPos(0, Canvas.CurY - YL);

	if ( TGRI.FragLimit > 0 )
	{
		Canvas.DrawText(FragGoal@TGRI.FragLimit);
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.CurY - YL);
	}

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText(TimeLimit@TGRI.TimeLimit$":00");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);

	Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{
	GrabPlayerVars();
	DrawPlayerName(Canvas);
	DrawPlayerPing(Canvas);
	DrawStats(Canvas);
	DrawScoreAndLevel(Canvas);
}

function DrawScoreAndLevel(Canvas Canvas)
{
local float X,Y,XL,YL;

	X = Canvas.ClipX * 0.5;
	Y = 420;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X - 264, Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y - 8);
	Canvas.DrawTile(Texture'Topp', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 259, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect3.fireeffect3', 518, 38, 0, 0, 518, 38);

	Canvas.Style = Style;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.StrLen("Score: "@int(PlayerPawn(Owner).PlayerReplicationInfo.Score)$" - Level: 1", XL, YL );
	Canvas.SetPos(X - XL * 0.5, Y + 4);
	Canvas.DrawColor = GoldColor;
	Canvas.DrawText("Score: "@int(PlayerPawn(Owner).PlayerReplicationInfo.Score)$" - Level: "@ShowLevel, False);
}

function DrawStats(Canvas Canvas)
{
local float X,Y,XL,YL;

	//Draw Damage Done (AddToDamage variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y = 212;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddToDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Damage Done", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Damage Done", false );
	Canvas.StrLen(ShowAddToDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowAddToDamage$"%", false );

	//Draw Health Regain (RegainHealth variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'RegainHealth', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Health Regain Rate", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Health Regain Rate", false );
	Canvas.StrLen(ShowHealthRegain$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowHealthRegain$"%", false );

	//Draw Regain Ammo (RegainAmmo variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y += 52;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'RegainAmmo', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Regain Ammo Rate", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Regain Ammo Rate", false );
	Canvas.StrLen(ShowAmmoRegain$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowAmmoRegain$"%", false );

	//Draw Reduce Damage (ReduceDamage variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'ReduceDamageTaken', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Reduce Damage Taken", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Reduce Damage Taken", false );
	Canvas.StrLen(ShowReducedDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowReducedDamage$"%", false );

	//Draw Fire Damage (AddFireDamage variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y += 52;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddFireDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Add Fire Damage", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Add Fire Damage", false );
	Canvas.StrLen(ShowFireDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowFireDamage$"%", false );

	//Draw Lightning Damage (AddLightningDamage variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddLightningDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Add Lightning Damage", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Add Lightning Damage", false );
	Canvas.StrLen(ShowLightningDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowLightningDamage$"%", false );

	//Draw Poison Damage (AddPoisonDamage variable)
	X = Canvas.ClipX * 0.5 - 264;
	Y += 52;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddPoisonDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Add Poison Damage", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Add Poison Damage", false );
	Canvas.StrLen(ShowPoisonDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowPoisonDamage$"%", false );

	//Draw Cold Damage (AddColdDamage variable)
	X = Canvas.ClipX * 0.5 + 16;
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X , Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X , Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X , Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 240, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y - 8);
	Canvas.DrawTile(Texture'Topp', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 8, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 232, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 43, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect56.fireeffect56', 199, 38, 0, 0, 199, 60);
	Canvas.SetPos(X + 4, Y - 4);
	Canvas.DrawTile(Texture'AddColdDamage', 40, 40, 0, 0, 64, 64);
	Canvas.DrawColor = GreenColor;
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.StrLen("Add Cold Damage", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y);
	Canvas.DrawText("Add Cold Damage", false );
	Canvas.StrLen(ShowColdDamage$"%", XL, YL );
	Canvas.SetPos(X + 145 - XL * 0.5, Y + 16);
	Canvas.DrawText(ShowColdDamage$"%", false );
}

function DrawPlayerPing(Canvas Canvas)
{
	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(CanVas.ClipX * 0.5 + 266, 161);
	Canvas.DrawTile(Texture'DisconnectWarn', 32, 32, 0, 0, 64, 64);
	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);

	if (PlayerPawn(Owner).PlayerReplicationInfo.Ping < 100)
		Canvas.DrawColor = GreenColor;
	else if (PlayerPawn(Owner).PlayerReplicationInfo.Ping < 250)
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = RedColor;

	Canvas.SetPos(CanVas.ClipX * 0.5 + 300, 169);
	Canvas.DrawText(PlayerPawn(Owner).PlayerReplicationInfo.Ping, false );
}

function DrawPlayerName(Canvas Canvas)
{
local float X,Y,XL,YL;

	X = Canvas.ClipX * 0.5;
	Y = 160;

	Canvas.DrawColor = WhiteColor; 
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(X - 264, Y - 8);
	Canvas.DrawTile(Texture'TopLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y - 8);
	Canvas.DrawTile(Texture'TopRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y );
	Canvas.DrawTile(Texture'Left', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y );
	Canvas.DrawTile(Texture'Right', 8, 32, 0, 0, 8, 8);
	Canvas.SetPos(X - 264, Y + 32);
	Canvas.DrawTile(Texture'BottomLeft', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X + 256, Y +32);
	Canvas.DrawTile(Texture'BottomRight', 8, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y - 8);
	Canvas.DrawTile(Texture'Topp', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 256, Y + 32);
	Canvas.DrawTile(Texture'Bottom', 512, 8, 0, 0, 8, 8);
	Canvas.SetPos(X - 259, Y - 3);
	Canvas.DrawTile(Texture'UnrealShare.Effect3.fireeffect3', 518, 38, 0, 0, 518, 38);

	Canvas.Style = Style;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.StrLen(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName, XL, YL );
	Canvas.SetPos(X - XL * 0.5, Y + 4);
	Canvas.DrawColor = GoldColor;
	Canvas.DrawText(PlayerPawn(Owner).PlayerReplicationInfo.PlayerName, False);
}


function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	// Draw Name

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.1875, YOffset);
	Canvas.DrawText(PlayerOwner.PlayerReplicationInfo.PlayerName, False);

	Canvas.StrLen( "0000", XL, YL );

	// Draw Score
	
	Canvas.StrLen( int(PlayerOwner.PlayerReplicationInfo.Score), XL2, YL );
	Canvas.SetPos( Canvas.ClipX * 0.625 + XL * 0.5 - XL2, YOffset );
	Canvas.DrawText( int(PlayerOwner.PlayerReplicationInfo.Score), false );

	// Draw Deaths
	Canvas.StrLen( int(PlayerOwner.PlayerReplicationInfo.Deaths), XL2, YL );
	Canvas.SetPos( Canvas.ClipX * 0.75 + XL * 0.5 - XL2, YOffset );
	Canvas.DrawText( int(PlayerOwner.PlayerReplicationInfo.Deaths), false );

	if (Canvas.ClipX > 512)
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.Font = MyFonts.GetSmallestFont(Canvas.ClipX);

		// Draw Time
		Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
		Canvas.TextSize( TimeString$": 999", XL3, YL3 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset );
		Canvas.DrawText( TimeString$":"@Time, false );

		// Draw FPH
		Canvas.TextSize( FPHString$": 999", XL2, YL2 );
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL, YOffset + 0.5 * YL );
		Canvas.DrawText( FPHString$": "@int(60 * PlayerOwner.PlayerReplicationInfo.Score/Time), false );

		XL3 = FMax(XL3, XL2);
		// Draw Ping
		Canvas.SetPos( Canvas.ClipX * 0.75 + XL + XL3 + 16, YOffset );
		Canvas.DrawText( PingString$":"@PlayerOwner.PlayerReplicationInfo.Ping, false );
		}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
	YStart = Canvas.CurY;
	YOffset = YStart;

	Canvas.SetPos(0, 0);
	YOffset = YStart + I * YL;
	//DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );

	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The match has ended."
     ElapsedTime="Elapsed Time: "
     RemainingTime="Remaining Time: "
     FragGoal="Frag Limit:"
     TimeLimit="Time Limit:"
     PlayerString="Player"
     FragsString="Score"
     DeathsString="Deaths"
     PingString="Ping"
     TimeString="Time"
     LossString="Loss"
     FPHString="FPH"
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     WallPaperColor=(R=64,G=64,B=64)
}
